dataset_name = 'OliveOil';
% dir_parent = '/Users/liuyiyao/Documents/UB_study/Research/Experiments/early_classification/';
dir_parent = '/local/Liuyi/early_classification_ucr/';
TRAIN_DIR = strcat(dir_parent,'data/', dataset_name, '/', strcat(dataset_name, '_TRAIN'));
TRAIN_DIR
TEST_DIR = strcat(dir_parent,'data/', dataset_name, '/', strcat(dataset_name, '_TEST'));

% load('/Users/liuyiyao/Documents/UB_study/Research/Experiments/early_classification/data/CBF/CBF_TRAIN')
% load('/Users/liuyiyao/Documents/UB_study/Research/Experiments/early_classification/data/CBF/CBF_TEST')
load(TRAIN_DIR);
load(TEST_DIR);
%%
% TRAIN = CBF_TEST(1:100, :);
% TEST = CBF_TRAIN;
TRAIN = OliveOil_TRAIN; %--------------------------------->
TEST = OliveOil_TEST;%--------------------------------->
%%
rng(5);
subsequence_cell = sample_subsequence( TRAIN, 20, 40, 5 );
 %% extract candidate shapelet
candidate_shapelet_cell = {};
ind = 1;
for i = 1: size(subsequence_cell,1)
    status = is_candidate_shapelet( TRAIN, subsequence_cell{i,1}, 0.85, subsequence_cell{i,2} );
    if status == 1
        candidate_shapelet_cell{ind, 1} = subsequence_cell{i,1};
        candidate_shapelet_cell{ind, 2} = subsequence_cell{i,2};
        candidate_shapelet_cell{ind, 3} = subsequence_cell{i,3};
        ind = ind+1;
    end
end

%% construct distance data
% train_distance_data = data_distance_construct(TRAIN, candidate_shapelet_cell)
num_train = size(TRAIN,1);
train_distance_data = cell(num_train,2);
for i = 1: num_train
       [train_distance_data{i,1},train_distance_data{i,2} ]= train_seq2shapelet( TRAIN(i,2:end), candidate_shapelet_cell ) ; 
end


num_test = size(TEST,1);
test_distance_data = cell(num_test,2);
for i = 1: num_test
       [test_distance_data{i,1},test_distance_data{i,2} ]= train_seq2shapelet( TEST(i,2:end), candidate_shapelet_cell ) ; 
end
%% generate group index
class_label = unique(TRAIN(:,1));
group_index = group_index_construct(candidate_shapelet_cell,class_label);

%% generate training data_label
num_train = size(TRAIN,1);
num_class = size(class_label,1);
class_label = unique(TRAIN(:,1));
for i = 1:num_train
    num_time = size(train_distance_data{i,2}, 1);
    train_distance_data{i, 3} = label_generation(TRAIN(i,1),class_label, num_time );
end

%% using logistic without glass
num_train = size(TRAIN,1);
num_class = size(class_label,1);
class_label = unique(TRAIN(:,1));


new_train = [];
label = [];
train_index = zeros(num_train, 2);
start = 1;
train_index(1,1) = start;
for i = 1:num_train
    new_train = [new_train;train_distance_data{i,1} ];
    label = [label;train_distance_data{i,3}  ];
    train_index(i,2) = train_index(i,1) + size(train_distance_data{i,3},1) -1;
    if i ~=num_train
        train_index(i+1) = train_index(i,2) + 1;
    end
    
end
[new_train_norm, mean_vec, sigma_vec] = normalize_data(new_train);
[B,dev,stats] = mnrfit(new_train_norm, label);

num_test = size(test_distance_data,1);
new_test = [];

test_index = zeros(num_test,2);
start = 1;
test_index(1,1) = start;
for i = 1:num_test
    new_test = [new_test;test_distance_data{i,1} ];
   test_index(i,2) = test_index(i,1) + size(test_distance_data{i,2},1) -1;
    if i ~=num_test
        test_index(i+1) = test_index(i,2) + 1;
    end
    
end
[new_test_norm, ~, ~] = normalize_data(new_test);

% prediction result
pihat_test_logis = mnrval(B,new_test_norm);
pihat_train_logis = mnrval(B, new_train_norm);

% cvglmnetPlot(cvfit)
 test_measurement = prediction_for_all_together( pihat_test_logis, test_index, TEST(:,1), 0.7 );
 test_measurement.accuracy
 train_measurement = prediction_for_all_together( pihat_train_logis, train_index, TRAIN(:,1), 0.7 );
 train_measurement.accuracy
mkdir(strcat(dir_parent,'result/', dataset_name));
save_logistic_path = strcat(dir_parent,'result/', dataset_name, '/', 'result_logistic.mat');
save(save_logistic_path, 'B');
save(save_logistic_path, 'test_measurement', '-append');
save(save_logistic_path, 'train_measurement', '-append');

%% logistic with glass


N = size(new_train_norm,1);
 F = size(new_train_norm,2);
 num_class = size(label,2);
 E = Earliness_cal(candidate_shapelet_cell);% F*1
 E = [0;E];
 X = [ones(N,1) new_train_norm]; % N*F
 L = zeros(N,num_class-1);
 for i = 1:num_class-1
    L(:,i) = log((label(:,i)+0.01)./(label(:,num_class)+0.01));
 end
 

 rng(5);
 W = B;
 A = randn(size(W))*0.1;
 U = randn(size(W))*0.1;
 lambda_1 = 0.5;
 lambda_2 = 0.5;
 rho = 0.5;
 loss = [];
 itelim = 10000;
 loss_previous = Inf;
 tmp = pinv(2*(X')*X + 2*lambda_1*E*(E') + rho * eye(F+1));
 for i = 1:itelim
%      fprintf('current iteration: %d \n', i);
     
     for j = 1:num_class-1
         tmp2 = (2*(X')*L(:,j)+ rho * A(:,j)-rho*U(:,j));
        W(:,j) = tmp * tmp2;
     end
     A = update_for_A(U, W, lambda_2, rho);
     U = U + W-A;

     loss(end+1) = norm(X*W -L, 'fro')^2;
     fprintf('current iteration: %d, loss %d \n', i, loss(end));
     if abs(loss(end)-previous_loss) < 0.000001|| loss(end) > loss_previous
         break;
     end
     previous_loss
 end

 

W_sparse = W;
for i = 1:size(W_sparse, 1)
    dim2 = size(W_sparse,2);
    indic = zeros(1, dim2);
    for j = 1:dim2
        if abs(W_sparse(i,j)) < 0.001
            indic(1, j) = 1;
        end
    end
    if sum(indic) == dim2
        W_sparse(i,:) = zeros(1,dim2);
    end
%     if abs(W_sparse(i,1)) < 0.001 && abs(W_sparse(i,2)) < 0.001
%         W_sparse(i,1) = 0;
%         W_sparse(i,2) = 0;
%     end
end

pihat_test = mnrval(W_sparse,new_test_norm);
pihat_train = mnrval(W_sparse, new_train_norm);

% cvglmnetPlot(cvfit)

 test_measurement = prediction_for_all_together( pihat_test, test_index, TEST(:,1), 0.5 );
 test_measurement.accuracy
 train_measurement = prediction_for_all_together( pihat_train, train_index, TRAIN(:,1), 0.5 );
 train_measurement.accuracy
 
 save_logistic_glasso_path = strcat(dir_parent,'result/', dataset_name, '/', 'result_logistic_glasso.mat');
 save(save_logistic_glasso_path, 'W');
 save(save_logistic_glasso_path, 'test_measurement', '-append');
 save(save_logistic_glasso_path, 'train_measurement', '-append');
  save(save_logistic_glasso_path, 'loss', '-append');

 
 
%  function [E] = Earliness_cal(candidate_cell)
%  num_feature = size(candidate_cell,1);
%  E = zeros(num_feature, 1);
%  for i = 1:num_feature
%      E(i,1) = candidate_cell{i,3};
%  end
%  end
% 
%  
%  
%  function updated_A = update_for_A(U_t, W_t, lambda_2, rho)
%     dim1 = size(W_t,1);
%     updated_A = zeros(size(W_t));
%     for i = 1:dim1
%         C = U_t(i,:) + W_t(i,:);
%         C_l2 = sum(abs(C).^2)^(1/2);
%         if(1-lambda_2/(rho*C_l2)) > 0
%             updated_A(i,:) = (1-lambda_2/(rho*C_l2))*C;
%         else
%             updated_A(i,:) = 0*C;
%         end
%     end
%  end



 

